CREATE TABLE IF NOT EXISTS `common_org_bu_treed`
(
    `id`                 bigint(19) NOT NULL COMMENT '记录唯一ID',
    `pid`                bigint(19) NOT NULL COMMENT '上级ID',
    `sort_no`            int(10)         DEFAULT NULL COMMENT '排序号',
    `level`              int(10)         DEFAULT NULL COMMENT '层级',
    `code_path`          varchar(255)    DEFAULT NULL COMMENT '树型结构编号全路径，使用/隔离',
    `bu_tree_id`         bigint(19)      DEFAULT NULL COMMENT '组织树ID',
    `bu_id`              bigint(19)      DEFAULT NULL COMMENT '组织ID',
    `bu_code`            varchar(40)     DEFAULT NULL COMMENT 'bu_code',
    `tenant_id`          bigint(19)      DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255)    DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(19)      DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255)    DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime   NULL DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(19)      DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255)    DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime   NULL DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(10)    NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(10)         DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(19)      DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(19)      DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(19)      DEFAULT NULL COMMENT 'sec_ou_id',
    PRIMARY KEY (`id`),
    KEY `idx_bu_tree_code_path` (`code_path`),
    KEY `idx_bu_tree_pid` (`pid`)
) COMMENT = '组织树明细';

CREATE TABLE IF NOT EXISTS `common_org_emp`
(
    `id`                 bigint(19) NOT NULL COMMENT '记录唯一ID',
    `pid`                bigint(19) NOT NULL COMMENT '上级ID',
    `sort_no`            int(10)         DEFAULT NULL COMMENT '排序号',
    `level`              int(10)         DEFAULT NULL COMMENT '层级',
    `code_path`          varchar(255)    DEFAULT NULL COMMENT '树型结构编号全路径，使用/隔离',
    `ou_id`              bigint(19)      DEFAULT NULL COMMENT '公司ID',
    `ou_code`            varchar(40)     DEFAULT NULL COMMENT '公司编号',
    `ou_name`            varchar(40)     DEFAULT NULL COMMENT '公司名称',
    `bu_id`              bigint(19)      DEFAULT NULL COMMENT 'BU ID',
    `bu_code`            varchar(40)     DEFAULT NULL COMMENT 'BU编号',
    `bu_name`            varchar(40)     DEFAULT NULL COMMENT 'BU名称',
    `emp_bu_id`          bigint(19)      DEFAULT NULL COMMENT '员工所属 BU ID',
    `emp_bu_tree_id`     bigint(19)      DEFAULT NULL COMMENT '员工所属BU树ID',
    `emp_bu_treedid`     bigint(19)      DEFAULT NULL COMMENT '员工所属BU树详情ID',
    `user_id`            bigint(19)      DEFAULT NULL COMMENT '用户id',
    `user_name`          varchar(40)     DEFAULT NULL COMMENT '用户名',
    `emp_code`           varchar(40)     DEFAULT NULL COMMENT '雇员编号',
    `emp_name`           varchar(40)     DEFAULT NULL COMMENT '雇员姓名',
    `emp_type`           varchar(255)    DEFAULT NULL COMMENT '员工类型 [UDC]ORG:EMP_TYPE',
    `emp_type2`          varchar(40)     DEFAULT NULL COMMENT '员工类型2',
    `emp_type3`          varchar(40)     DEFAULT NULL COMMENT '员工类型3',
    `emp_status`         varchar(40)     DEFAULT NULL COMMENT '员工状态 [UDC]ORG:EMP_STATUS',
    `foreign_name`       varchar(40)     DEFAULT NULL COMMENT '雇员外文名',
    `addr_no`            bigint(19)      DEFAULT NULL COMMENT '地址号',
    `emp_gender`         varchar(40)     DEFAULT NULL COMMENT '员工性别',
    `birth_date`         datetime   NULL DEFAULT NULL COMMENT '出生日期',
    `email`              varchar(40)     DEFAULT NULL COMMENT '工作邮箱',
    `mobile`             varchar(40)     DEFAULT NULL COMMENT '工作手机号',
    `id_type`            varchar(40)     DEFAULT NULL COMMENT '证件类型',
    `id_no`              varchar(255)    DEFAULT NULL COMMENT '证件号码',
    `emp_level`          varchar(40)     DEFAULT NULL COMMENT '职级',
    `title`              varchar(40)     DEFAULT NULL COMMENT '行政职位, [UDC]ORG:TITLE',
    `join_date`          datetime   NULL DEFAULT NULL COMMENT '入职日期',
    `jdy_flag`           int(10)         DEFAULT '1' COMMENT '是否同步激荡云,默认 1 ',
    `leave_date`         datetime   NULL DEFAULT NULL COMMENT '离职日期',
    `tenant_id`          bigint(19)      DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255)    DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(19)      DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255)    DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime   NULL DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(19)      DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255)    DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime   NULL DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(10)    NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(10)         DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(19)      DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(19)      DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(19)      DEFAULT NULL COMMENT 'sec_ou_id',
    PRIMARY KEY (`id`),
    KEY `idx_emp_code_path` (`code_path`),
    KEY `idx_emp_pid` (`pid`)
) COMMENT = '员工';

CREATE TABLE IF NOT EXISTS `com_c1`
(
    `id`                 bigint(19) NOT NULL COMMENT '记录唯一ID',
    `ou_id`              bigint(19)      DEFAULT '0' COMMENT '公司ID',
    `c13type`            varchar(32)     DEFAULT NULL COMMENT '分类类型',
    `c1code`             varchar(32)     DEFAULT NULL COMMENT '大类编码',
    `c1name`             varchar(32)     DEFAULT NULL COMMENT '大类名称',
    `abbr_name`          varchar(32)     DEFAULT NULL COMMENT '简称',
    `sort_no`            int(10)         DEFAULT '0' COMMENT '排序号',
    `es1`                varchar(32)     DEFAULT NULL COMMENT '预留字符串1',
    `es2`                varchar(32)     DEFAULT NULL COMMENT '预留字符串2',
    `es3`                varchar(32)     DEFAULT NULL COMMENT '预留字符串3',
    `es4`                varchar(32)     DEFAULT NULL COMMENT '预留字符串4',
    `es5`                varchar(32)     DEFAULT NULL COMMENT '预留字符串5',
    `es6`                varchar(32)     DEFAULT NULL COMMENT '预留字符串6',
    `es7`                varchar(32)     DEFAULT NULL COMMENT '预留字符串7',
    `es8`                varchar(32)     DEFAULT NULL COMMENT '预留字符串8',
    `es9`                varchar(32)     DEFAULT NULL COMMENT '预留字符串9',
    `es10`               varchar(32)     DEFAULT NULL COMMENT '预留字符串10',
    `en1`                decimal(18)     DEFAULT '0.0000' COMMENT '预留浮点数1',
    `en2`                decimal(18)     DEFAULT '0.0000' COMMENT '预留浮点数2',
    `en3`                decimal(18)     DEFAULT '0.0000' COMMENT '预留浮点数3',
    `en4`                decimal(18)     DEFAULT '0.0000' COMMENT '预留浮点数4',
    `en5`                decimal(18)     DEFAULT '0.0000' COMMENT '预留浮点数5',
    `ed1`                datetime   NULL DEFAULT NULL COMMENT '预留日期时间1',
    `ed2`                datetime   NULL DEFAULT NULL COMMENT '预留日期时间2',
    `ed3`                datetime   NULL DEFAULT NULL COMMENT '预留日期时间3',
    `tenant_id`          bigint(19)      DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255)    DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(19)      DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255)    DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime   NULL DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(19)      DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255)    DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime   NULL DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(10)         DEFAULT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(10)         DEFAULT NULL COMMENT '锁版本',
    PRIMARY KEY (`id`),
    KEY `create_user_id_index` (`create_user_id`)
) COMMENT = '大类';

CREATE TABLE IF NOT EXISTS `com_c2`
(
    `id`                 bigint(19) NOT NULL COMMENT '记录唯一ID',
    `ou_id`              bigint(19)      DEFAULT '0' COMMENT '公司ID',
    `c13type`            varchar(32)     DEFAULT NULL COMMENT '分类类型',
    `c2code`             varchar(32)     DEFAULT NULL COMMENT '中类编码',
    `c2name`             varchar(32)     DEFAULT NULL COMMENT '中类名称',
    `abbr_name`          varchar(32)     DEFAULT NULL COMMENT '简称',
    `c1code`             varchar(32)     DEFAULT NULL COMMENT '大类编码',
    `sort_no`            int(10)         DEFAULT '0' COMMENT '排序号',
    `es1`                varchar(32)     DEFAULT NULL COMMENT '预留字符串1',
    `es2`                varchar(32)     DEFAULT NULL COMMENT '预留字符串2',
    `es3`                varchar(32)     DEFAULT NULL COMMENT '预留字符串3',
    `es4`                varchar(32)     DEFAULT NULL COMMENT '预留字符串4',
    `es5`                varchar(32)     DEFAULT NULL COMMENT '预留字符串5',
    `es6`                varchar(32)     DEFAULT NULL COMMENT '预留字符串6',
    `es7`                varchar(32)     DEFAULT NULL COMMENT '预留字符串7',
    `es8`                varchar(32)     DEFAULT NULL COMMENT '预留字符串8',
    `es9`                varchar(32)     DEFAULT NULL COMMENT '预留字符串9',
    `es10`               varchar(32)     DEFAULT NULL COMMENT '预留字符串10',
    `en1`                decimal(18)     DEFAULT '0.0000' COMMENT '预留浮点数1',
    `en2`                decimal(18)     DEFAULT '0.0000' COMMENT '预留浮点数2',
    `en3`                decimal(18)     DEFAULT '0.0000' COMMENT '预留浮点数3',
    `en4`                decimal(18)     DEFAULT '0.0000' COMMENT '预留浮点数4',
    `en5`                decimal(18)     DEFAULT '0.0000' COMMENT '预留浮点数5',
    `ed1`                datetime   NULL DEFAULT NULL COMMENT '预留日期时间1',
    `ed2`                datetime   NULL DEFAULT NULL COMMENT '预留日期时间2',
    `ed3`                datetime   NULL DEFAULT NULL COMMENT '预留日期时间3',
    `tenant_id`          bigint(19)      DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255)    DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(19)      DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255)    DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime   NULL DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(19)      DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255)    DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime   NULL DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(10)         DEFAULT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(10)         DEFAULT NULL COMMENT '锁版本',
    PRIMARY KEY (`id`),
    KEY `create_user_id_index` (`create_user_id`)
) COMMENT = '中类';

CREATE TABLE IF NOT EXISTS `com_city_code`
(
    `id`                 bigint(19)  NOT NULL AUTO_INCREMENT COMMENT '记录唯一ID',
    `area_name`          varchar(40) NOT NULL COMMENT '区域名称',
    `area_code`          varchar(40) NOT NULL COMMENT '区域代码',
    `area_type`          varchar(40)      DEFAULT NULL COMMENT '区域类型',
    `short_name`         varchar(40)      DEFAULT NULL COMMENT '区域简称',
    `english_name`       varchar(40)      DEFAULT NULL COMMENT '英文名称',
    `area_level`         varchar(40)      DEFAULT NULL COMMENT '区域等级',
    `pid`                bigint(19)  NOT NULL COMMENT '上级ID',
    `area_status`        varchar(40)      DEFAULT NULL COMMENT '地址状态',
    `area_spell`         varchar(40)      DEFAULT NULL COMMENT '汉语拼音',
    `area_shspell`       varchar(40)      DEFAULT NULL COMMENT '拼音首字母',
    `tel_head`           varchar(40)      DEFAULT NULL COMMENT '区号',
    `zip_code`           varchar(40)      DEFAULT NULL COMMENT '邮编',
    `area_desc`          varchar(255)     DEFAULT NULL COMMENT '区域描述',
    `tenant_id`          bigint(19)       DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255)     DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(19)       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255)     DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime    NULL DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(19)       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255)     DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime    NULL DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(10)     NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(10)          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(19)       DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(19)       DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(19)       DEFAULT NULL COMMENT 'sec_ou_id',
    PRIMARY KEY (`id`),
    UNIQUE KEY `uk_area_area_code` (`area_code`),
    KEY `create_user_id_index` (`create_user_id`),
    KEY `idx_area_area_name` (`area_name`),
    KEY `idx_area_pid` (`pid`),
    KEY `sec_bu_id_index` (`sec_bu_id`),
    KEY `sec_ou_id_index` (`sec_ou_id`),
    KEY `sec_user_id_index` (`sec_user_id`)
) COMMENT = '区域定义';

CREATE TABLE IF NOT EXISTS `com_curr`
(
    `id`                 bigint(19) NOT NULL COMMENT '唯一编号ID',
    `curr_code`          varchar(40)     DEFAULT NULL COMMENT '币种代码',
    `curr_name`          varchar(40)     DEFAULT NULL COMMENT '币种名称',
    `disp_decimal`       int(10)         DEFAULT NULL COMMENT '显示小数位数',
    `enable_flag`        int(10)         DEFAULT NULL COMMENT '是否有效',
    `tenant_id`          bigint(19)      DEFAULT '0' COMMENT '租户ID',
    `remark`             varchar(255)    DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(19)      DEFAULT '0' COMMENT '记录创建者ID',
    `create_time`        datetime   NULL DEFAULT NULL COMMENT 'create_time',
    `modify_user_id`     bigint(19)      DEFAULT '0' COMMENT '记录最后更新者ID',
    `modify_time`        datetime   NULL DEFAULT NULL COMMENT 'modify_time',
    `delete_flag`        int(10)         DEFAULT '0' COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(10)         DEFAULT '0' COMMENT '版本信息，前端不用传',
    `creator`            varchar(255)    DEFAULT NULL COMMENT '记录创建者',
    `updater`            varchar(255)    DEFAULT NULL COMMENT '记录最后更新者',
    `ou_id`              bigint(19)      DEFAULT NULL COMMENT '公司ID',
    `sec_bu_id`          bigint(19)      DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(19)      DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(19)      DEFAULT NULL COMMENT 'sec_ou_id',
    PRIMARY KEY (`id`),
    UNIQUE KEY `uk_curr_code` (`curr_code`),
    KEY `create_user_id_index` (`create_user_id`),
    KEY `curr_code` (`curr_code`),
    KEY `sec_bu_id_index` (`sec_bu_id`),
    KEY `sec_ou_id_index` (`sec_ou_id`),
    KEY `sec_user_id_index` (`sec_user_id`)
) COMMENT = '币种';

CREATE TABLE IF NOT EXISTS `com_curr_rate`
(
    `id`                 bigint(19) NOT NULL AUTO_INCREMENT COMMENT '唯一编号ID',
    `ou_id`              int(10)         DEFAULT NULL COMMENT '公司ID',
    `rate_type`          varchar(40)     DEFAULT NULL COMMENT '汇率类型',
    `rate_type2`         varchar(40)     DEFAULT NULL COMMENT '汇率类型2',
    `rate_type3`         varchar(40)     DEFAULT NULL COMMENT '汇率类型3',
    `rate_status`        varchar(40)     DEFAULT NULL COMMENT '汇率状态',
    `rate_status2`       varchar(40)     DEFAULT NULL COMMENT '汇率状态2',
    `rate_source`        varchar(40)     DEFAULT NULL COMMENT '汇率来源',
    `from_curr`          varchar(40)     DEFAULT NULL COMMENT '从币种',
    `to_curr`            varchar(40)     DEFAULT NULL COMMENT '到币种',
    `cal_method`         varchar(40)     DEFAULT NULL COMMENT '计算方法',
    `ratio`              float(20)       DEFAULT NULL COMMENT '汇率',
    `ratio2`             float(20)       DEFAULT NULL COMMENT '汇率2',
    `ratio3`             float(20)       DEFAULT NULL COMMENT '汇率3',
    `valid_from`         datetime   NULL DEFAULT NULL COMMENT '生效日期',
    `valid_to`           datetime   NULL DEFAULT NULL COMMENT '失效日期',
    `period_id`          int(10)         DEFAULT NULL COMMENT '期间ID',
    `tenant_id`          bigint(19)      DEFAULT '0' COMMENT '租户ID',
    `remark`             varchar(255)    DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(19)      DEFAULT '0' COMMENT '记录创建者ID',
    `create_time`        datetime   NULL DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(19)      DEFAULT '0' COMMENT '记录最后更新者ID',
    `modify_time`        datetime   NULL DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(10)         DEFAULT '0' COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(10)         DEFAULT '0' COMMENT '版本信息，前端不用传',
    `creator`            varchar(255)    DEFAULT NULL COMMENT '记录创建者',
    `updater`            varchar(255)    DEFAULT NULL COMMENT '记录最后更新者',
    `sec_bu_id`          bigint(19)      DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(19)      DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(19)      DEFAULT NULL COMMENT 'sec_ou_id',
    PRIMARY KEY (`id`),
    KEY `create_user_id_index` (`create_user_id`),
    KEY `sec_bu_id_index` (`sec_bu_id`),
    KEY `sec_ou_id_index` (`sec_ou_id`),
    KEY `sec_user_id_index` (`sec_user_id`)
) COMMENT = '汇率';

CREATE TABLE IF NOT EXISTS `com_district`
(
    `id`                 bigint(19)  NOT NULL AUTO_INCREMENT COMMENT '唯一编号ID',
    `dist_code`          varchar(32) NOT NULL COMMENT '区划代码',
    `dist_name`          varchar(64) NOT NULL COMMENT '区划名称',
    `dist_name2`         varchar(64)      DEFAULT NULL COMMENT '区划名称2',
    `dist_type`          varchar(32)      DEFAULT NULL COMMENT '区划类型',
    `dist_type2`         varchar(32)      DEFAULT NULL COMMENT '区划类型2',
    `dist_type3`         varchar(32)      DEFAULT NULL COMMENT '区划类型33',
    `abbr_name`          varchar(32)      DEFAULT NULL COMMENT '区划简称',
    `country`            varchar(32)      DEFAULT NULL COMMENT '国家码: COM:COUNTRY',
    `province`           varchar(32)      DEFAULT NULL COMMENT '省份、州码：COM:STATE',
    `city`               varchar(32)      DEFAULT NULL COMMENT '城市码：COM:CITY',
    `county`             varchar(32)      DEFAULT NULL COMMENT '区县码: COM:COUNTY',
    `street`             varchar(128)     DEFAULT NULL COMMENT '乡镇街道',
    `dist_level`         varchar(32)      DEFAULT NULL COMMENT '区域等级',
    `dist_level_num`     int(10)          DEFAULT '0' COMMENT '区域等级数值',
    `parent_id`          bigint(19)       DEFAULT '0' COMMENT '上级ID',
    `parent_code`        varchar(32)      DEFAULT NULL COMMENT '上级代码',
    `path`               varchar(1024)    DEFAULT NULL COMMENT '路径',
    `dist_status`        varchar(32)      DEFAULT NULL COMMENT '地址状态',
    `dist_pinyin`        varchar(256)     DEFAULT NULL COMMENT '汉语拼音',
    `dist_pinyin_caps`   varchar(32)      DEFAULT NULL COMMENT '拼音首字母',
    `tel_head`           varchar(32)      DEFAULT NULL COMMENT '电话区号',
    `zip_code`           varchar(16)      DEFAULT NULL COMMENT '邮编',
    `dist_desc`          varchar(256)     DEFAULT NULL COMMENT '区域描述',
    `es1`                varchar(64)      DEFAULT NULL COMMENT '扩展字符串1',
    `es2`                varchar(64)      DEFAULT NULL COMMENT '扩展字符串2',
    `es3`                varchar(64)      DEFAULT NULL COMMENT '扩展字符串3',
    `tenant_id`          bigint(19)       DEFAULT '0' COMMENT '租户ID',
    `remark`             varchar(255)     DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(19)       DEFAULT '0' COMMENT '记录创建者ID',
    `create_time`        datetime    NULL DEFAULT NULL COMMENT 'create_time',
    `modify_user_id`     bigint(19)       DEFAULT '0' COMMENT '记录最后更新者ID',
    `modify_time`        datetime    NULL DEFAULT NULL COMMENT 'modify_time',
    `delete_flag`        int(10)          DEFAULT '0' COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(10)          DEFAULT '0' COMMENT '版本信息，前端不用传',
    `p_id`               bigint(19)       DEFAULT '0' COMMENT '上级ID',
    `p_code`             varchar(32)      DEFAULT NULL COMMENT '上级代码',
    `creator`            varchar(255)     DEFAULT NULL COMMENT '记录创建者',
    `updater`            varchar(255)     DEFAULT NULL COMMENT '记录最后更新者',
    `sec_bu_id`          bigint(19)       DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(19)       DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(19)       DEFAULT NULL COMMENT 'sec_ou_id',
    PRIMARY KEY (`id`),
    KEY `create_user_id_index` (`create_user_id`),
    KEY `dist_code` (`dist_code`),
    KEY `dist_code_2` (`dist_code`, `dist_level_num`),
    KEY `sec_bu_id_index` (`sec_bu_id`),
    KEY `sec_ou_id_index` (`sec_ou_id`),
    KEY `sec_user_id_index` (`sec_user_id`)
) COMMENT = '行政区划';

CREATE TABLE IF NOT EXISTS `com_payment_term`
(
    `id`                 bigint(19) NOT NULL COMMENT '唯一编号ID',
    `pt_code`            varchar(40)     DEFAULT NULL COMMENT '代码',
    `pt_name`            varchar(40)     DEFAULT NULL COMMENT '名称',
    `days`               int(10)         DEFAULT NULL COMMENT '天数',
    `base_day_type`      varchar(40)     DEFAULT NULL COMMENT '基于日期类型',
    `day_calc_method`    varchar(40)     DEFAULT NULL COMMENT '日期计算方式 是否含工作日',
    `due_day`            datetime   NULL DEFAULT NULL COMMENT '到期日期',
    `enable_flag`        int(10)         DEFAULT '0' COMMENT '是否有效',
    `tenant_id`          bigint(19)      DEFAULT '0' COMMENT '租户ID',
    `remark`             varchar(255)    DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(19)      DEFAULT '0' COMMENT '记录创建者ID',
    `create_time`        datetime   NULL DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(19)      DEFAULT '0' COMMENT '记录最后更新者ID',
    `modify_time`        datetime   NULL DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(10)         DEFAULT '0' COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(10)         DEFAULT '0' COMMENT '版本信息，前端不用传',
    `valid_from`         datetime   NULL DEFAULT NULL COMMENT '生效日期',
    `valid_to`           datetime   NULL DEFAULT NULL COMMENT '失效日期',
    `creator`            varchar(255)    DEFAULT NULL COMMENT '记录创建者',
    `updater`            varchar(255)    DEFAULT NULL COMMENT '记录最后更新者',
    `sec_bu_id`          bigint(19)      DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(19)      DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(19)      DEFAULT NULL COMMENT 'sec_ou_id',
    `account_code`       varchar(40)     DEFAULT NULL COMMENT '对账报账编码',
    PRIMARY KEY (`id`),
    KEY `create_user_id_index` (`create_user_id`),
    KEY `pt_code` (`pt_code`),
    KEY `sec_bu_id_index` (`sec_bu_id`),
    KEY `sec_ou_id_index` (`sec_ou_id`),
    KEY `sec_user_id_index` (`sec_user_id`)
) COMMENT = '支付条款 币种 此表使用CODE来引用，不使用ID。';

CREATE TABLE IF NOT EXISTS `com_tax_code`
(
    `id`                 bigint(19) NOT NULL AUTO_INCREMENT COMMENT '记录唯一ID',
    `tax_name`           varchar(40)     DEFAULT NULL COMMENT '税区/税码',
    `tenant_id`          bigint(19)      DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255)    DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(19)      DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255)    DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime   NULL DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(19)      DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255)    DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime   NULL DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(10)         DEFAULT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(10)         DEFAULT NULL COMMENT '锁版本',
    `tax_type`           varchar(40)     DEFAULT NULL COMMENT '税区',
    `tax_code`           varchar(40)     DEFAULT NULL COMMENT '税码',
    PRIMARY KEY (`id`),
    KEY `create_user_id_index` (`create_user_id`)
) COMMENT = '税码';

CREATE TABLE IF NOT EXISTS `com_tax_rate`
(
    `id`                 bigint(19) NOT NULL AUTO_INCREMENT COMMENT '唯一编号ID',
    `ou_id`              bigint(19)      DEFAULT NULL COMMENT '公司ID',
    `tax_rate_no`        varchar(40)     DEFAULT NULL COMMENT '税率编号',
    `tax_rate_desc`      varchar(40)     DEFAULT NULL COMMENT '税率说明',
    `valid_from`         datetime   NULL DEFAULT NULL COMMENT '生效日期',
    `valid_to`           datetime   NULL DEFAULT NULL COMMENT '失效日期',
    `tax_rate_value`     float(20)       DEFAULT NULL COMMENT '税率值',
    `tenant_id`          bigint(19)      DEFAULT '0' COMMENT '租户ID',
    `remark`             varchar(255)    DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(19)      DEFAULT '0' COMMENT '记录创建者ID',
    `create_time`        datetime   NULL DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(19)      DEFAULT '0' COMMENT '记录最后更新者ID',
    `modify_time`        datetime   NULL DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(10)         DEFAULT '0' COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(10)         DEFAULT '0' COMMENT '版本信息，前端不用传',
    `tax_rate_index`     varchar(40)     DEFAULT NULL COMMENT '税率索引 [UOM]COM:TAX_RATE_INDEX',
    `creator`            varchar(255)    DEFAULT NULL COMMENT '记录创建者',
    `updater`            varchar(255)    DEFAULT NULL COMMENT '记录最后更新者',
    `sec_bu_id`          bigint(19)      DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(19)      DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(19)      DEFAULT NULL COMMENT 'sec_ou_id',
    PRIMARY KEY (`id`),
    KEY `create_user_id_index` (`create_user_id`),
    KEY `sec_bu_id_index` (`sec_bu_id`),
    KEY `sec_ou_id_index` (`sec_ou_id`),
    KEY `sec_user_id_index` (`sec_user_id`),
    KEY `tax_rate_no` (`tax_rate_no`)
) COMMENT = '税率';

CREATE TABLE IF NOT EXISTS `flyway_schema_history`
(
    `installed_rank` int(10)       NOT NULL COMMENT 'installed_rank',
    `version`        varchar(50) DEFAULT NULL COMMENT 'version',
    `description`    varchar(200)  NOT NULL COMMENT 'description',
    `type`           varchar(20)   NOT NULL COMMENT 'type',
    `script`         varchar(1000) NOT NULL COMMENT 'script',
    `checksum`       int(10)     DEFAULT NULL COMMENT 'checksum',
    `installed_by`   varchar(100)  NOT NULL COMMENT 'installed_by',
    `installed_on`   timestamp     NOT NULL COMMENT 'installed_on',
    `execution_time` int(10)       NOT NULL COMMENT 'execution_time',
    `success`        tinyint(3)    NOT NULL COMMENT 'success',
    PRIMARY KEY (`installed_rank`),
    KEY `flyway_schema_history_s_idx` (`success`)
) COMMENT = 'flyway_schema_history';

CREATE TABLE IF NOT EXISTS `hibernate_sequence`
(
    `next_val` bigint(19) DEFAULT NULL COMMENT 'next_val'
) COMMENT = 'hibernate_sequence';

CREATE TABLE IF NOT EXISTS `rocket_transaction_log`
(
    `id`             bigint(19)   NOT NULL AUTO_INCREMENT COMMENT 'id',
    `transaction_id` varchar(100) NOT NULL COMMENT '事务id',
    `doc_code`       varchar(100) DEFAULT NULL COMMENT '文件编号标识',
    `project`        varchar(200) DEFAULT NULL COMMENT '项目标识',
    `business`       varchar(200) DEFAULT NULL COMMENT '业务标识',
    `extend_json`    varchar(200) DEFAULT NULL COMMENT '扩展信息',
    PRIMARY KEY (`id`),
    UNIQUE KEY `UK_t6h3pd6fijdux5e1fvvrtx99g` (`transaction_id`)
) COMMENT = 'rocketmnq事务日志';

CREATE TABLE IF NOT EXISTS `sys_biz_constraint`
(
    `id`                 bigint(19) NOT NULL COMMENT '记录唯一ID',
    `data_role_code`     varchar(255)    DEFAULT NULL COMMENT '数据角色编码',
    `data_role_name`     varchar(255)    DEFAULT NULL COMMENT '数据角色名称',
    `domain_code`        varchar(255)    DEFAULT NULL COMMENT '领域编码',
    `domain_name`        varchar(255)    DEFAULT NULL COMMENT '领域名称',
    `table_code`         varchar(255)    DEFAULT NULL COMMENT '表编码',
    `table_name`         varchar(255)    DEFAULT NULL COMMENT '表名称',
    `field_code`         varchar(255)    DEFAULT NULL COMMENT '表字段编码',
    `field_caption`      varchar(255)    DEFAULT NULL COMMENT '字段名称',
    `field_type`         varchar(255)    DEFAULT NULL COMMENT '字段类型',
    `udc_domain_code`    varchar(255)    DEFAULT NULL COMMENT 'UDC的Domain Code',
    `udc_code`           varchar(255)    DEFAULT NULL COMMENT 'UDC的UDC Code',
    `default_value`      varchar(255)    DEFAULT NULL COMMENT '默认值',
    `compare_op_code`    varchar(255)    DEFAULT NULL COMMENT '比较符编码',
    `compare_op_name`    varchar(255)    DEFAULT NULL COMMENT '比较符名称',
    `constraint_values`  varchar(255)    DEFAULT NULL COMMENT '约束值, 多值采用逗号分隔',
    `tenant_id`          bigint(19)      DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255)    DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(19)      DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255)    DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime   NULL DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(19)      DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255)    DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime   NULL DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(10)    NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(10)         DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(19)      DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(19)      DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(19)      DEFAULT NULL COMMENT 'sec_ou_id',
    `field_udc_type`     varchar(255)    DEFAULT NULL COMMENT '逻辑UDC字段类型META:FLDTYPE',
    `meta_column_id`     bigint(19)      DEFAULT NULL COMMENT '元数据列的记录ID',
    PRIMARY KEY (`id`)
) COMMENT = '业务数据权限约束';

CREATE TABLE IF NOT EXISTS `sys_butable`
(
    `id`           bigint(19) NOT NULL AUTO_INCREMENT COMMENT '主键',
    `butable_name` varchar(128) DEFAULT NULL COMMENT '表名称',
    `use_null`     int(10)      DEFAULT NULL COMMENT '是否可以使用空值 1:可以 0:不可以',
    `delete_flag`  int(10)      DEFAULT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    PRIMARY KEY (`id`)
) COMMENT = 'sys_butable';

CREATE TABLE IF NOT EXISTS `sys_database_source`
(
    `id`                 bigint(19)   NOT NULL COMMENT '记录唯一ID',
    `dbs_name`           varchar(64)  NOT NULL COMMENT '数据源名称',
    `dbs_driver_class`   varchar(64)  NOT NULL COMMENT '驱动类',
    `dbs_url`            varchar(256) NOT NULL COMMENT '连接地址',
    `dbs_username`       varchar(64)  NOT NULL COMMENT '驱动类',
    `dbs_password`       varchar(64)  NOT NULL COMMENT '驱动类',
    `tenant_id`          bigint(19)        DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255)      DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(19)        DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255)      DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime     NULL DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(19)        DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255)      DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime     NULL DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(10)      NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(10)           DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(19)        DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(19)        DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(19)        DEFAULT NULL COMMENT 'sec_ou_id',
    PRIMARY KEY (`id`),
    UNIQUE KEY `UK_5mh7yibgt1q5tlovw1mt6isw1` (`dbs_url`),
    UNIQUE KEY `UK_qrmqns00nx8p2jgk46jk79ysl` (`dbs_name`)
) COMMENT = '数据源表';

CREATE TABLE IF NOT EXISTS `sys_data_role`
(
    `id`                 bigint(19)  NOT NULL COMMENT '记录唯一ID',
    `code`               varchar(40) NOT NULL COMMENT '数据角色代码',
    `name`               varchar(40) NOT NULL COMMENT '数据角色名称',
    `advanced_enable`    int(10)     NOT NULL COMMENT '是否取用高级授权',
    `enabled`            int(10)          DEFAULT NULL COMMENT '是否启用',
    `tenant_id`          bigint(19)       DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255)     DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(19)       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255)     DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime    NULL DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(19)       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255)     DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime    NULL DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(10)     NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(10)          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(19)       DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(19)       DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(19)       DEFAULT NULL COMMENT 'sec_ou_id',
    `business_enable`    int(10)          DEFAULT NULL COMMENT 'business_enable',
    PRIMARY KEY (`id`),
    UNIQUE KEY `UK_cem7cq6iwip27be1ik1724rtq` (`code`),
    KEY `create_user_id_index` (`create_user_id`),
    KEY `sec_bu_id_index` (`sec_bu_id`),
    KEY `sec_ou_id_index` (`sec_ou_id`),
    KEY `sec_user_id_index` (`sec_user_id`)
) COMMENT = '系统数据角色表';

CREATE TABLE IF NOT EXISTS `sys_data_role_auth`
(
    `id`                   bigint(19) NOT NULL COMMENT '记录唯一ID',
    `data_role_id`         bigint(19)      DEFAULT NULL COMMENT '关联的数据角色ID',
    `is_basic`             int(10)         DEFAULT NULL COMMENT '是否基础数据授权：1 是，0 否',
    `permission_id`        bigint(19)      DEFAULT NULL COMMENT '高级授权应用ID',
    `permission_code`      varchar(255)    DEFAULT NULL COMMENT '高级授权应用Code',
    `is_permit_all`        int(10)    NOT NULL COMMENT '是否全部授权全部数据',
    `emp_auth_enable`      int(10)         DEFAULT NULL COMMENT '是否启用员工授权',
    `emp_auth_scope`       varchar(40)     DEFAULT NULL COMMENT '员工数据权限授权范围',
    `emp_customize_enable` int(10)         DEFAULT NULL COMMENT '员工是否启用自定义授权',
    `bu_auth_enable`       int(10)         DEFAULT NULL COMMENT '是否启用组织授权',
    `bu_auth_scope`        varchar(40)     DEFAULT NULL COMMENT '组织数据权限授权范围',
    `bu_customize_enable`  int(10)         DEFAULT NULL COMMENT '组织是否启用自定义授权',
    `tenant_id`            bigint(19)      DEFAULT NULL COMMENT '租户ID',
    `remark`               varchar(255)    DEFAULT NULL COMMENT '备注',
    `create_user_id`       bigint(19)      DEFAULT NULL COMMENT '记录创建者ID',
    `creator`              varchar(255)    DEFAULT NULL COMMENT '记录创建者',
    `create_time`          datetime   NULL DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`       bigint(19)      DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`              varchar(255)    DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`          datetime   NULL DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`          int(10)    NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version`   int(10)         DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`            bigint(19)      DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`          bigint(19)      DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`            bigint(19)      DEFAULT NULL COMMENT 'sec_ou_id',
    `ou_auth_enable`       int(10)         DEFAULT NULL COMMENT '是否启用公司授权',
    `ou_auth_scope`        varchar(40)     DEFAULT NULL COMMENT '公司数据权限授权范围',
    `ou_customize_enable`  int(10)         DEFAULT NULL COMMENT '公司是否启用自定义授权',
    PRIMARY KEY (`id`),
    KEY `create_user_id_index` (`create_user_id`),
    KEY `sec_bu_id_index` (`sec_bu_id`),
    KEY `sec_ou_id_index` (`sec_ou_id`),
    KEY `sec_user_id_index` (`sec_user_id`)
) COMMENT = '系统数据角色授权表';

CREATE TABLE IF NOT EXISTS `sys_data_role_auth_customize`
(
    `id`                 bigint(19) NOT NULL COMMENT '记录唯一ID',
    `data_role_auth_id`  bigint(19)      DEFAULT NULL COMMENT '数据角色授权信息ID',
    `customize_type`     varchar(40)     DEFAULT NULL COMMENT '自定义类型：人员还是组织',
    `sec_id`             bigint(19)      DEFAULT NULL COMMENT '自定义授权数据ID',
    `sec_code`           varchar(40)     DEFAULT NULL COMMENT '自定义授权数据CODE',
    `sec_name`           varchar(40)     DEFAULT NULL COMMENT '自定义授权数据名称',
    `tenant_id`          bigint(19)      DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255)    DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(19)      DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255)    DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime   NULL DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(19)      DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255)    DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime   NULL DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(10)    NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(10)         DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(19)      DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(19)      DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(19)      DEFAULT NULL COMMENT 'sec_ou_id',
    PRIMARY KEY (`id`),
    KEY `create_user_id_index` (`create_user_id`),
    KEY `sec_bu_id_index` (`sec_bu_id`),
    KEY `sec_ou_id_index` (`sec_ou_id`),
    KEY `sec_user_id_index` (`sec_user_id`)
) COMMENT = '系统数据角色自定义授权表';

CREATE TABLE IF NOT EXISTS `sys_flow_role`
(
    `id`                 bigint(19)  NOT NULL COMMENT '记录唯一ID',
    `code`               varchar(16) NOT NULL COMMENT '角色代码',
    `name`               varchar(32) NOT NULL COMMENT '角色名称',
    `enabled`            int(10)          DEFAULT NULL COMMENT '是否启用',
    `tenant_id`          bigint(19)       DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255)     DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(19)       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255)     DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime    NULL DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(19)       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255)     DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime    NULL DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(10)     NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(10)          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(19)       DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(19)       DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(19)       DEFAULT NULL COMMENT 'sec_ou_id',
    PRIMARY KEY (`id`),
    UNIQUE KEY `UK_k7iim1lyhuyr06xn6jdj8vei1` (`code`)
) COMMENT = '流程角色表';

CREATE TABLE IF NOT EXISTS `sys_front_config`
(
    `id`                 bigint(19) NOT NULL COMMENT '记录唯一ID',
    `role_id`            bigint(19)      DEFAULT NULL COMMENT '绑定的应用角色ID',
    `permission_id`      bigint(19)      DEFAULT NULL COMMENT '绑定的权限ID',
    `config_code`        varchar(40)     DEFAULT NULL COMMENT '配置编号',
    `config_context`     longtext        DEFAULT NULL COMMENT '配置内容',
    `tenant_id`          bigint(19)      DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255)    DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(19)      DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255)    DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime   NULL DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(19)      DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255)    DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime   NULL DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(10)    NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(10)         DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(19)      DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(19)      DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(19)      DEFAULT NULL COMMENT 'sec_ou_id',
    PRIMARY KEY (`id`),
    KEY `idx_config_code` (`config_code`)
) COMMENT = '前端表单，表格动态配置';

CREATE TABLE IF NOT EXISTS `sys_next_number`
(
    `id`                 bigint(19)   NOT NULL AUTO_INCREMENT COMMENT '记录唯一ID',
    `code`               varchar(255) NOT NULL COMMENT '下一编号代码',
    `name`               varchar(255) NOT NULL COMMENT '下一编号名称',
    `number_class`       varchar(255)      DEFAULT NULL COMMENT '下一编号分类',
    `step`               int(10)           DEFAULT NULL COMMENT '下一编号步长',
    `next_number`        bigint(19)        DEFAULT NULL COMMENT '下一编号取值',
    `nn_period`          varchar(255)      DEFAULT NULL COMMENT '下一编号周期',
    `nn_time`            datetime     NULL DEFAULT NULL COMMENT '发号时间',
    `version`            int(10)           DEFAULT NULL COMMENT '乐观锁标记',
    `tenant_id`          bigint(19)        DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255)      DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(19)        DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255)      DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime     NULL DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(19)        DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255)      DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime     NULL DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(10)           DEFAULT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(10)           DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(19)        DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(19)        DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(19)        DEFAULT NULL COMMENT 'sec_ou_id',
    PRIMARY KEY (`id`),
    UNIQUE KEY `UK_s6xdfqu3p37tc3a6gpsc23mq8` (`code`),
    KEY `create_user_id_index` (`create_user_id`),
    KEY `sec_bu_id_index` (`sec_bu_id`),
    KEY `sec_ou_id_index` (`sec_ou_id`),
    KEY `sec_user_id_index` (`sec_user_id`)
) COMMENT = '取号下一编号表';

CREATE TABLE IF NOT EXISTS `sys_number_rule`
(
    `id`                 bigint(19)   NOT NULL AUTO_INCREMENT COMMENT '记录唯一ID',
    `rule_code`          varchar(255) NOT NULL COMMENT '规则编号',
    `rule_name`          varchar(64)       DEFAULT NULL COMMENT '规则名称',
    `rule_class`         varchar(32)       DEFAULT NULL COMMENT '规则分类码：sys:numrulcls',
    `sample_code`        varchar(255)      DEFAULT NULL COMMENT '取号示例',
    `tenant_id`          bigint(19)        DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255)      DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(19)        DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255)      DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime     NULL DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(19)        DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255)      DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime     NULL DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(10)           DEFAULT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(10)           DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(19)        DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(19)        DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(19)        DEFAULT NULL COMMENT 'sec_ou_id',
    PRIMARY KEY (`id`),
    UNIQUE KEY `UK_3904pugpu38vqwlg4aussvgr1` (`rule_code`),
    KEY `create_user_id_index` (`create_user_id`),
    KEY `sec_bu_id_index` (`sec_bu_id`),
    KEY `sec_ou_id_index` (`sec_ou_id`),
    KEY `sec_user_id_index` (`sec_user_id`)
) COMMENT = '发号器规则';

CREATE TABLE IF NOT EXISTS `sys_number_ruledtl`
(
    `id`                 bigint(19) NOT NULL AUTO_INCREMENT COMMENT '记录唯一ID',
    `rule_id`            bigint(19)      DEFAULT NULL COMMENT '发号器规则ID',
    `seq`                int(10)         DEFAULT NULL COMMENT '排序号',
    `number_type`        varchar(255)    DEFAULT NULL COMMENT '取号类型：sys:numbertype',
    `number_pattern`     varchar(255)    DEFAULT NULL COMMENT '取号模式，根据取号类型填写对应的固定字符串、日期格式化字符串、自增序号码',
    `nn_len`             int(10)         DEFAULT NULL COMMENT '自增序号宽度，默认左补零',
    `tenant_id`          bigint(19)      DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255)    DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(19)      DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255)    DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime   NULL DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(19)      DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255)    DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime   NULL DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(10)         DEFAULT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(10)         DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(19)      DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(19)      DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(19)      DEFAULT NULL COMMENT 'sec_ou_id',
    PRIMARY KEY (`id`),
    KEY `create_user_id_index` (`create_user_id`),
    KEY `idx_sys_number_ruledtl_rule_id` (`rule_id`),
    KEY `sec_bu_id_index` (`sec_bu_id`),
    KEY `sec_ou_id_index` (`sec_ou_id`),
    KEY `sec_user_id_index` (`sec_user_id`)
) COMMENT = '发号器规则明细';

CREATE TABLE IF NOT EXISTS `sys_permission`
(
    `id`                 bigint(19)   NOT NULL AUTO_INCREMENT COMMENT '账号唯一ID',
    `code`               varchar(128) NOT NULL COMMENT '权限代码',
    `name`               varchar(64)  NOT NULL COMMENT '权限名称',
    `perm_type`          int(10)           DEFAULT NULL COMMENT '权限类型',
    `parent_id`          bigint(19)        DEFAULT NULL COMMENT '父权限ID',
    `path`               varchar(255)      DEFAULT NULL COMMENT '权限层级路径',
    `perm_level`         int(10)           DEFAULT NULL COMMENT '权限层级',
    `sort_no`            int(10)           DEFAULT NULL COMMENT '排列顺序',
    `pattern`            varchar(255)      DEFAULT NULL COMMENT 'URL路径模式',
    `http_method`        varchar(32)       DEFAULT NULL COMMENT 'URL的HTTP方法[COM:HTTP_METH]',
    `tenant_id`          bigint(19)        DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255)      DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(19)        DEFAULT NULL COMMENT '记录创建者ID',
    `create_time`        datetime     NULL DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(19)        DEFAULT NULL COMMENT '记录最后更新者ID',
    `modify_time`        datetime     NULL DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(10)           DEFAULT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(10)           DEFAULT NULL COMMENT '版本',
    `creator`            varchar(255)      DEFAULT NULL COMMENT '记录创建者',
    `updater`            varchar(255)      DEFAULT NULL COMMENT '记录最后更新者',
    `icon`               varchar(255)      DEFAULT NULL COMMENT '菜单图标',
    `is_hidden`          int(10)           DEFAULT NULL COMMENT '菜单是否隐藏',
    `sec_bu_id`          bigint(19)        DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(19)        DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(19)        DEFAULT NULL COMMENT 'sec_ou_id',
    `terminal_code`               varchar(64)  DEFAULT NULL COMMENT '多端',
    PRIMARY KEY (`id`),
    KEY `create_user_id_index` (`create_user_id`),
    KEY `idx_sys_permission_pid` (`parent_id`),
    KEY `sec_bu_id_index` (`sec_bu_id`),
    KEY `sec_ou_id_index` (`sec_ou_id`),
    KEY `sec_user_id_index` (`sec_user_id`)
) COMMENT = '系统权限表，包括URL、操作';

CREATE TABLE IF NOT EXISTS `sys_quick_entry`
(
    `id`                 bigint(19) NOT NULL COMMENT '记录唯一ID',
    `quick_data`         varchar(1024)   DEFAULT NULL COMMENT '快捷入口数据：前端传递，后端直接返回',
    `tenant_id`          bigint(19)      DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255)    DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(19)      DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255)    DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime   NULL DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(19)      DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255)    DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime   NULL DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(10)         DEFAULT '0' COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(10)         DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(19)      DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(19)      DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(19)      DEFAULT NULL COMMENT 'sec_ou_id',
    PRIMARY KEY (`id`)
) COMMENT = '系统快捷入口配置';

CREATE TABLE IF NOT EXISTS `sys_rocket_mq_consume_fail_log`
(
    `id`                 bigint(19) NOT NULL COMMENT '记录唯一ID',
    `type_id`            int(10)         DEFAULT NULL COMMENT '消费失败类型：1：消费次数过多，2：业务异常，3：长时间无法消费,4:其他',
    `already_deal`       varchar(255)    DEFAULT NULL COMMENT '消费失败是否已处理；PROCESSED：已处理，TO_BE_PROCESSED:待处理',
    `consumer_kye`       varchar(64)     DEFAULT NULL COMMENT '消息体key',
    `consumer_group`     varchar(256)    DEFAULT NULL COMMENT '消费者组',
    `consumer_topic`     varchar(128)    DEFAULT NULL COMMENT '消费主题',
    `message_detail`     varchar(1024)   DEFAULT NULL COMMENT '消费数据详情',
    `tenant_id`          bigint(19)      DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255)    DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(19)      DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255)    DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime   NULL DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(19)      DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255)    DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime   NULL DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(10)         DEFAULT '0' COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(10)         DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(19)      DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(19)      DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(19)      DEFAULT NULL COMMENT 'sec_ou_id',
    `consumer_key`       varchar(64)     DEFAULT NULL COMMENT '消息体key',
    `consumer_boby`      longblob        DEFAULT NULL COMMENT '消息体',
    `consumer_tag`       varchar(128)    DEFAULT NULL COMMENT 'consumer_tag',
    `message_uuid`       varchar(255)    DEFAULT NULL COMMENT '消息UUID',
    PRIMARY KEY (`id`),
    UNIQUE KEY `UKgrpk942r3l233crbyf36p0xpx` (`consumer_key`)
) COMMENT = '架构补偿机制-消费失败记录';

CREATE TABLE IF NOT EXISTS `sys_rocket_mq_consume_log`
(
    `id`                 bigint(19) NOT NULL COMMENT '记录唯一ID',
    `line_num`           bigint(19)      DEFAULT NULL COMMENT '消息行号',
    `consumer_kye`       varchar(64)     DEFAULT NULL COMMENT '消息体key',
    `consumer_group`     varchar(256)    DEFAULT NULL COMMENT '消费者组',
    `consumer_topic`     varchar(128)    DEFAULT NULL COMMENT '消费主题',
    `is_success`         int(10)         DEFAULT NULL COMMENT '是否消费成功:true:成功，false:失败',
    `fail_detail`        varchar(255)    DEFAULT NULL COMMENT '失败详情',
    `tenant_id`          bigint(19)      DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255)    DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(19)      DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255)    DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime   NULL DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(19)      DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255)    DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime   NULL DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(10)         DEFAULT '0' COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(10)         DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(19)      DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(19)      DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(19)      DEFAULT NULL COMMENT 'sec_ou_id',
    `queue_id`           int(10)         DEFAULT NULL COMMENT '消息体key',
    `message_id`         varchar(255)    DEFAULT NULL COMMENT '消息标识',
    `message_uuid`       varchar(255)    DEFAULT NULL COMMENT '消息UUID',
    `reconsume_times`    int(10)         DEFAULT NULL COMMENT '消息标识',
    `consumer_key`       varchar(64)     DEFAULT NULL COMMENT '消息体key',
    PRIMARY KEY (`id`)
) COMMENT = '架构补偿机制-消费记录';

CREATE TABLE IF NOT EXISTS `sys_role`
(
    `id`                 bigint(19)  NOT NULL AUTO_INCREMENT COMMENT '账号唯一ID',
    `code`               varchar(16) NOT NULL COMMENT '角色代码',
    `name`               varchar(32) NOT NULL COMMENT '角色名称',
    `enabled`            int(10)          DEFAULT NULL COMMENT '是否启用',
    `tenant_id`          bigint(19)       DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255)     DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(19)       DEFAULT NULL COMMENT '记录创建者ID',
    `create_time`        datetime    NULL DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(19)       DEFAULT NULL COMMENT '记录最后更新者ID',
    `modify_time`        datetime    NULL DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(10)          DEFAULT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(10)          DEFAULT NULL COMMENT '版本',
    `creator`            varchar(255)     DEFAULT NULL COMMENT '记录创建者',
    `updater`            varchar(255)     DEFAULT NULL COMMENT '记录最后更新者',
    `sec_bu_id`          bigint(19)       DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(19)       DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(19)       DEFAULT NULL COMMENT 'sec_ou_id',
    `tenant_name`        varchar(64)      DEFAULT NULL COMMENT '所属租户名称',
    PRIMARY KEY (`id`),
    KEY `create_user_id_index` (`create_user_id`),
    KEY `sec_bu_id_index` (`sec_bu_id`),
    KEY `sec_ou_id_index` (`sec_ou_id`),
    KEY `sec_user_id_index` (`sec_user_id`),
    KEY `UK_plpigyqwsqfn7mn66npgf9ftp` (`code`)
) COMMENT = '系统角色表';

CREATE TABLE IF NOT EXISTS `sys_role_ou`
(
    `id`                 bigint(19)  NOT NULL COMMENT '记录唯一ID',
    `ou_id`              bigint(19)       DEFAULT NULL COMMENT '公司ID',
    `ou_name`            varchar(32) NOT NULL COMMENT '公司名称',
    `role_id`            bigint(19)       DEFAULT NULL COMMENT '角色ID',
    `role_name`          varchar(32) NOT NULL COMMENT '角色名称',
    `role_type`          int(10)     NOT NULL COMMENT '角色类型：0：应用角色，1 数据角色  目前仅支持数据角色',
    `username`           varchar(32) NOT NULL COMMENT '用户账号名称',
    `last_name`          varchar(256)     DEFAULT NULL COMMENT '用户姓氏',
    `first_name`         varchar(256)     DEFAULT NULL COMMENT '用户名称',
    `user_id`            bigint(19)       DEFAULT NULL COMMENT '用户Id',
    `tenant_id`          bigint(19)       DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255)     DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(19)       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255)     DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime    NULL DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(19)       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255)     DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime    NULL DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(10)     NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(10)          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(19)       DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(19)       DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(19)       DEFAULT NULL COMMENT 'sec_ou_id',
    PRIMARY KEY (`id`),
    UNIQUE KEY `UK_ajal0xja8q14kapqpgxq9hynj` (`username`)
) COMMENT = '系统角色与公司表';

CREATE TABLE IF NOT EXISTS `sys_role_permission`
(
    `id`                 bigint(19) NOT NULL COMMENT '账号唯一ID',
    `role_id`            bigint(19)      DEFAULT NULL COMMENT '角色ID',
    `permission_id`      bigint(19)      DEFAULT NULL COMMENT '权限ID',
    `tenant_id`          bigint(19)      DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255)    DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(19)      DEFAULT NULL COMMENT '记录创建者ID',
    `create_time`        datetime   NULL DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(19)      DEFAULT NULL COMMENT '记录最后更新者ID',
    `modify_time`        datetime   NULL DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(10)         DEFAULT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(10)         DEFAULT NULL COMMENT '版本',
    `creator`            varchar(255)    DEFAULT NULL COMMENT '记录创建者',
    `updater`            varchar(255)    DEFAULT NULL COMMENT '记录最后更新者',
    `sec_bu_id`          bigint(19)      DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(19)      DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(19)      DEFAULT NULL COMMENT 'sec_ou_id',
    PRIMARY KEY (`id`),
    KEY `create_user_id_index` (`create_user_id`),
    KEY `idx_role_permission_permission` (`permission_id`),
    KEY `idx_role_permission_role` (`role_id`),
    KEY `sec_bu_id_index` (`sec_bu_id`),
    KEY `sec_ou_id_index` (`sec_ou_id`),
    KEY `sec_user_id_index` (`sec_user_id`)
) COMMENT = '角色权限关联表';

CREATE TABLE IF NOT EXISTS `sys_role_resources`
(
    `id`                 bigint(19) NOT NULL COMMENT '记录唯一ID',
    `role_id`            bigint(19)      DEFAULT NULL COMMENT '角色ID',
    `resources_id`       bigint(19)      DEFAULT NULL COMMENT '资源ID',
    `tenant_id`          bigint(19)      DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255)    DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(19)      DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255)    DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime   NULL DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(19)      DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255)    DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime   NULL DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(10)    NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(10)         DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(19)      DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(19)      DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(19)      DEFAULT NULL COMMENT 'sec_ou_id',
    PRIMARY KEY (`id`)
) COMMENT = '角色资源关联表';

CREATE TABLE IF NOT EXISTS `sys_setting`
(
    `id`                 bigint(19) NOT NULL AUTO_INCREMENT COMMENT '记录唯一ID',
    `setting_no`         varchar(40)     DEFAULT NULL COMMENT '设置编号',
    `setting_name`       varchar(40)     DEFAULT NULL COMMENT '设置名',
    `setting_type`       varchar(40)     DEFAULT NULL COMMENT '设置类型',
    `setting_type2`      varchar(40)     DEFAULT NULL COMMENT '设置类型2',
    `setting_type3`      varchar(40)     DEFAULT NULL COMMENT '设置类型3',
    `setting_status`     varchar(40)     DEFAULT NULL COMMENT '设置状态',
    `setting_desc`       varchar(500)    DEFAULT NULL COMMENT '设置描述',
    `setting_val`        varchar(500)    DEFAULT NULL COMMENT '设置值',
    `def_val`            varchar(100)    DEFAULT NULL COMMENT '默认值',
    `sort_no`            int(10)         DEFAULT NULL COMMENT '排序号',
    `tenant_id`          bigint(19)      DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255)    DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(19)      DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255)    DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime   NULL DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(19)      DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255)    DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime   NULL DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(10)         DEFAULT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(10)         DEFAULT NULL COMMENT '锁版本',
    `email`              varchar(32)     DEFAULT NULL COMMENT '设置类型3',
    `sec_bu_id`          bigint(19)      DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(19)      DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(19)      DEFAULT NULL COMMENT 'sec_ou_id',
    PRIMARY KEY (`id`),
    KEY `create_user_id_index` (`create_user_id`),
    KEY `sec_bu_id_index` (`sec_bu_id`),
    KEY `sec_ou_id_index` (`sec_ou_id`),
    KEY `sec_user_id_index` (`sec_user_id`)
) COMMENT = '设置项';

CREATE TABLE IF NOT EXISTS `sys_tenant`
(
    `id`                 bigint(19)       NOT NULL COMMENT '记录唯一ID',
    `tenant_code`        varchar(255)     NOT NULL COMMENT '租户编码',
    `tenant_name`        varchar(255)     NOT NULL COMMENT '租户名称',
    `sys_user_id`        bigint(19)       NOT NULL COMMENT '管理员的用户ID',
    `admin_account`      varchar(255)     NOT NULL COMMENT '管理员的登录账号',
    `tenant_type`        varchar(225)     NOT NULL COMMENT '租户类型',
    `enabled`            tinyint(3)       NOT NULL COMMENT '是否启用',
    `linkman`            varchar(255)          DEFAULT NULL COMMENT '联系人',
    `contact_number`     varchar(255)          DEFAULT NULL COMMENT '联系电话',
    `address`            varchar(255)          DEFAULT NULL COMMENT '联系地址',
    `tenant_isolation`   varchar(32)      NOT NULL COMMENT '租户数据隔离',
    `db_initialized`     tinyint(3)       NOT NULL COMMENT '数据库是否已初始化',
    `database_source_id` bigint(19)            DEFAULT NULL COMMENT '租户数据隔离数据源',
    `schema_name`        varchar(255)     NOT NULL COMMENT 'schema名称，如果租户数据隔离通过schema',
    `tenant_domain`      varchar(256)          DEFAULT NULL COMMENT '域名地址',
    `custom_domain`      varchar(400)          DEFAULT NULL COMMENT '租户自定义域名',
    `tenant_id`          bigint(19)            DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255)          DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(19)            DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255)          DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime         NULL DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(19)            DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255)          DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime         NULL DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(10) unsigned NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(10)               DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(19)            DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(19)            DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(19)            DEFAULT NULL COMMENT 'sec_ou_id',
    PRIMARY KEY (`id`),
    KEY `idx_sys_tenant_code` (`tenant_code`)
) COMMENT = '平台租户表';

CREATE TABLE IF NOT EXISTS `sys_tenant_db_migrate`
(
    `id`                  bigint(19)       NOT NULL COMMENT '主键ID',
    `sys_tenant_id`       bigint(19)       NOT NULL COMMENT '租户ID',
    `app_code`            varchar(255)     NOT NULL COMMENT '应用编码',
    `tenant_isolation`    varchar(32)      NOT NULL COMMENT '租户数据隔离',
    `database_source_id`  bigint(19)            DEFAULT NULL COMMENT '租户数据隔离数据源',
    `schema_name`         varchar(255)     NOT NULL COMMENT 'schema名称，如果租户数据隔离通过schema',
    `migrate_success`     tinyint(3)       NOT NULL COMMENT '是否迁移成功',
    `migrate_start_time`  datetime         NULL DEFAULT NULL COMMENT '迁移开始时间',
    `migrate_finish_time` datetime         NULL DEFAULT NULL COMMENT '迁移结束时间',
    `fail_reason`         text                  DEFAULT NULL COMMENT '更新失败原因',
    `tenant_id`           bigint(19)            DEFAULT NULL COMMENT '租户ID',
    `remark`              varchar(255)          DEFAULT NULL COMMENT '备注',
    `create_user_id`      bigint(19)            DEFAULT NULL COMMENT '记录创建者ID',
    `creator`             varchar(255)          DEFAULT NULL COMMENT '记录创建者',
    `create_time`         datetime         NULL DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`      bigint(19)            DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`             varchar(255)          DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`         datetime         NULL DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`         int(10) unsigned NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version`  int(10)               DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`           bigint(19)            DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`         bigint(19)            DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`           bigint(19)            DEFAULT NULL COMMENT 'sec_ou_id',
    PRIMARY KEY (`id`),
    KEY `idx_tenant_db_migrate_tenant_id` (`sys_tenant_id`)
) COMMENT = '租户数据库的创建记录';

CREATE TABLE IF NOT EXISTS `sys_tenant_user`
(
    `id`                 bigint(19) NOT NULL COMMENT '记录唯一ID',
    `sys_user_id`        bigint(19) NOT NULL COMMENT '用户ID',
    `sys_tenant_id`      bigint(19) NOT NULL COMMENT '租户ID',
    `bind_time`          datetime   NOT NULL COMMENT '绑定时间',
    `last_login_time`    datetime   NULL DEFAULT NULL COMMENT '上次登录时间',
    `tenant_id`          bigint(19)      DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255)    DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(19)      DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255)    DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime   NULL DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(19)      DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255)    DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime   NULL DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(10)    NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(10)         DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(19)      DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(19)      DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(19)      DEFAULT NULL COMMENT 'sec_ou_id',
    PRIMARY KEY (`id`),
    KEY `idx_tenant_user_tenant_id` (`sys_tenant_id`),
    KEY `idx_tenant_user_user_id` (`sys_user_id`)
) COMMENT = '用户与租户的绑定关系';

CREATE TABLE IF NOT EXISTS `sys_udc`
(
    `id`                 bigint(19)  NOT NULL AUTO_INCREMENT COMMENT '记录唯一ID',
    `domain_code`        varchar(32) NOT NULL COMMENT '领域码',
    `udc_code`           varchar(32) NOT NULL COMMENT 'UDC码',
    `udc_name`           varchar(64)      DEFAULT NULL COMMENT 'UDC码名称',
    `udc_val`            varchar(32) NOT NULL COMMENT 'UDC值',
    `val_desc`           varchar(64) NOT NULL COMMENT '值描述',
    `val_sort_no`        int(10)          DEFAULT NULL COMMENT '排序号',
    `hd_flag`            int(10)          DEFAULT NULL COMMENT '硬编码',
    `dp_flag`            int(10)          DEFAULT NULL COMMENT '是否开启数据权限',
    `es1`                varchar(32)      DEFAULT NULL COMMENT '扩展字段1-特殊处理',
    `es2`                varchar(32)      DEFAULT NULL COMMENT '扩展字段2',
    `es3`                varchar(32)      DEFAULT NULL COMMENT '扩展字段3',
    `es4`                varchar(32)      DEFAULT NULL COMMENT '扩展字段4',
    `es5`                varchar(32)      DEFAULT NULL COMMENT '扩展字段5',
    `es6`                varchar(32)      DEFAULT NULL COMMENT '扩展字段6',
    `es7`                varchar(32)      DEFAULT NULL COMMENT '扩展字段7',
    `es8`                varchar(32)      DEFAULT NULL COMMENT '扩展字段8',
    `ef1`                double           DEFAULT NULL COMMENT '扩展浮点1',
    `ef2`                double           DEFAULT NULL COMMENT '扩展浮点2',
    `ef3`                double           DEFAULT NULL COMMENT '扩展浮点3',
    `ef4`                double           DEFAULT NULL COMMENT '扩展浮点4',
    `ei1`                int(10)          DEFAULT NULL COMMENT '扩展整数1',
    `ei2`                int(10)          DEFAULT NULL COMMENT '扩展整数2',
    `ei3`                int(10)          DEFAULT NULL COMMENT '扩展整数3',
    `ei4`                int(10)          DEFAULT NULL COMMENT '扩展整数4',
    `ed1`                datetime    NULL DEFAULT NULL COMMENT '扩展日期1',
    `ed2`                datetime    NULL DEFAULT NULL COMMENT '扩展日期2',
    `ed3`                datetime    NULL DEFAULT NULL COMMENT '扩展日期3',
    `ed4`                datetime    NULL DEFAULT NULL COMMENT '扩展日期4',
    `tenant_id`          bigint(19)       DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255)     DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(19)       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255)     DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime    NULL DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(19)       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255)     DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime    NULL DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(10)          DEFAULT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(10)          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(19)       DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(19)       DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(19)       DEFAULT NULL COMMENT 'sec_ou_id',
    PRIMARY KEY (`id`),
    UNIQUE KEY `uk_domain_code_val` (`domain_code`, `udc_code`, `udc_val`)
) COMMENT = '分类码表';

CREATE TABLE IF NOT EXISTS `sys_user`
(
    `id`                 bigint(19)   NOT NULL AUTO_INCREMENT COMMENT '记录唯一ID',
    `username`           varchar(32)  NOT NULL COMMENT '用户账号名称',
    `last_name`          varchar(256)      DEFAULT NULL COMMENT '用户姓氏',
    `first_name`         varchar(256)      DEFAULT NULL COMMENT '用户名称',
    `mobile`             varchar(16)       DEFAULT NULL COMMENT '用户手机号码',
    `email`              varchar(32)       DEFAULT NULL COMMENT '用户邮箱地址',
    `password`           varchar(128) NOT NULL COMMENT '用户账号密码-hashed',
    `source_type`        varchar(32)       DEFAULT NULL COMMENT '账号来源, sys： 系统创建；wec：微信创建；oth：其他方式',
    `enabled`            int(10)           DEFAULT NULL COMMENT '是否启用',
    `trans_flag`         int(10)           DEFAULT '0' COMMENT '是否同步 0 未同步 1 已同步',
    `tenant_id`          bigint(19)        DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255)      DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(19)        DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255)      DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime     NULL DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(19)        DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255)      DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime     NULL DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(10)           DEFAULT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(10)           DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(19)        DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(19)        DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(19)        DEFAULT NULL COMMENT 'sec_ou_id',
    `need_reset`         int(10)           DEFAULT NULL COMMENT '密码是否需要重新设置',
    `wx_openid`          varchar(128)      DEFAULT NULL COMMENT '微信poenid',
    `ou_id`              bigint(19)        DEFAULT NULL COMMENT '用户所属公司ID',
    `ou_code`            varchar(40)       DEFAULT NULL COMMENT '用户所属公司编号',
    `ou_name`            varchar(40)       DEFAULT NULL COMMENT '用户所属公司名称',
    `bu_id`              bigint(19)        DEFAULT NULL COMMENT '用户所属组织ID',
    `avatar_url`         varchar(2048)     DEFAULT NULL COMMENT '用户头像地址，可直接访问，如微信头像地址等',
    `avatar_code`        varchar(32)       DEFAULT NULL COMMENT '用户头像在文件服务器中的标识',
    `full_name`          varchar(40)       DEFAULT NULL COMMENT '用户姓名',
    `user_type`          varchar(40)       DEFAULT NULL COMMENT '用户类型',
    `tenant_name`        varchar(65)       DEFAULT NULL COMMENT '所属租户名称',
    PRIMARY KEY (`id`),
    UNIQUE KEY `UK_51bvuyvihefoh4kp5syh2jpi4` (`username`),
    KEY `create_user_id_index` (`create_user_id`),
    KEY `idx_sys_user_mobile` (`mobile`),
    KEY `sec_bu_id_index` (`sec_bu_id`),
    KEY `sec_ou_id_index` (`sec_ou_id`),
    KEY `sec_user_id_index` (`sec_user_id`)
) COMMENT = '系统用户账号表';

CREATE TABLE IF NOT EXISTS `sys_user_company`
(
    `id`                 bigint(19) NOT NULL COMMENT '记录唯一ID',
    `sys_user_id`        bigint(19) NOT NULL COMMENT '用户ID',
    `ou_id`              bigint(19) NOT NULL COMMENT '公司ID',
    `ou_code`            varchar(255)    DEFAULT NULL COMMENT '公司编码',
    `ou_name`            varchar(255)    DEFAULT NULL COMMENT '公司名称',
    `bind_time`          datetime   NOT NULL COMMENT '绑定时间',
    `tenant_id`          bigint(19)      DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255)    DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(19)      DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255)    DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime   NULL DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(19)      DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255)    DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime   NULL DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(10)         DEFAULT '0' COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(10)         DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(19)      DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(19)      DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(19)      DEFAULT NULL COMMENT 'sec_ou_id',
    PRIMARY KEY (`id`),
    KEY `idx_sys_user_company_ou_id` (`ou_id`),
    KEY `idx_sys_user_company_user_id` (`sys_user_id`)
) COMMENT = '用户与公司关联表';

CREATE TABLE IF NOT EXISTS `sys_user_data_role`
(
    `id`                 bigint(19) NOT NULL COMMENT '记录唯一ID',
    `user_id`            bigint(19)      DEFAULT NULL COMMENT '账号ID',
    `role_id`            bigint(19)      DEFAULT NULL COMMENT '数据角色ID',
    `tenant_id`          bigint(19)      DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255)    DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(19)      DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255)    DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime   NULL DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(19)      DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255)    DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime   NULL DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(10)    NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(10)         DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(19)      DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(19)      DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(19)      DEFAULT NULL COMMENT 'sec_ou_id',
    PRIMARY KEY (`id`),
    KEY `create_user_id_index` (`create_user_id`),
    KEY `sec_bu_id_index` (`sec_bu_id`),
    KEY `sec_ou_id_index` (`sec_ou_id`),
    KEY `sec_user_id_index` (`sec_user_id`)
) COMMENT = '用户数据角色关联表';

CREATE TABLE IF NOT EXISTS `sys_user_flow_role`
(
    `id`                 bigint(19) NOT NULL COMMENT '记录唯一ID',
    `user_id`            bigint(19)      DEFAULT NULL COMMENT '账号ID',
    `role_id`            bigint(19)      DEFAULT NULL COMMENT '数据角色ID',
    `tenant_id`          bigint(19)      DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255)    DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(19)      DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255)    DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime   NULL DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(19)      DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255)    DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime   NULL DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(10)    NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(10)         DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(19)      DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(19)      DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(19)      DEFAULT NULL COMMENT 'sec_ou_id',
    PRIMARY KEY (`id`)
) COMMENT = '用户流程角色关联表';

CREATE TABLE IF NOT EXISTS `sys_user_proxy`
(
    `id`                 bigint(19)  NOT NULL COMMENT '记录唯一ID',
    `user_id`            bigint(19)       DEFAULT NULL COMMENT '被代理人id',
    `username`           varchar(32) NOT NULL COMMENT '被代理人用户账号名称',
    `mobile`             varchar(16)      DEFAULT NULL COMMENT '被代理人用户手机号码',
    `email`              varchar(32)      DEFAULT NULL COMMENT '被代理人用户邮箱地址',
    `ou_id`              bigint(19)       DEFAULT NULL COMMENT '被代理人用户所属公司ID',
    `ou_code`            varchar(40)      DEFAULT NULL COMMENT '被代理人用户所属公司编号',
    `ou_name`            varchar(40)      DEFAULT NULL COMMENT '被代理人用户所属公司名称',
    `bu_id`              bigint(19)       DEFAULT NULL COMMENT '被代理人用户所属组织ID',
    `proxy_user_id`      bigint(19)       DEFAULT NULL COMMENT '代理人id',
    `proxy_username`     varchar(32) NOT NULL COMMENT '代理人用户账号名称',
    `proxy_mobile`       varchar(16)      DEFAULT NULL COMMENT '代理人用户手机号码',
    `proxy_email`        varchar(32)      DEFAULT NULL COMMENT '代理人用户邮箱地址',
    `proxy_ou_id`        bigint(19)       DEFAULT NULL COMMENT '代理人用户所属公司ID',
    `proxy_ou_code`      varchar(40)      DEFAULT NULL COMMENT '代理人用户所属公司编号',
    `proxy_ou_name`      varchar(40)      DEFAULT NULL COMMENT '代理人用户所属公司名称',
    `proxy_bu_id`        bigint(19)       DEFAULT NULL COMMENT '代理人用户所属组织ID',
    `open_flag`          int(10)          DEFAULT NULL COMMENT '是否开启-0：开启，1关闭',
    `effect_start_time`  datetime    NULL DEFAULT NULL COMMENT '代理生效开始时间',
    `effect_end_time`    datetime    NULL DEFAULT NULL COMMENT '代理生效结束时间',
    `tenant_id`          bigint(19)       DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255)     DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(19)       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255)     DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime    NULL DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(19)       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255)     DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime    NULL DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(10)     NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(10)          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(19)       DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(19)       DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(19)       DEFAULT NULL COMMENT 'sec_ou_id',
    PRIMARY KEY (`id`),
    UNIQUE KEY `UK_al4cbi2jpu3dc3128lomq2s88` (`proxy_username`),
    UNIQUE KEY `UK_asmyoj2xbixiyvpymex71uihg` (`username`)
) COMMENT = '被代理用户与代理用户关系表';

CREATE TABLE IF NOT EXISTS `sys_user_role`
(
    `id`                 bigint(19) NOT NULL AUTO_INCREMENT COMMENT '账号唯一ID',
    `user_id`            bigint(19)      DEFAULT NULL COMMENT '用户ID',
    `role_id`            bigint(19)      DEFAULT NULL COMMENT '角色ID',
    `tenant_id`          bigint(19)      DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255)    DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(19)      DEFAULT NULL COMMENT '记录创建者ID',
    `create_time`        datetime   NULL DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(19)      DEFAULT NULL COMMENT '记录最后更新者ID',
    `modify_time`        datetime   NULL DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(10)         DEFAULT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(10)         DEFAULT NULL COMMENT '版本',
    `creator`            varchar(255)    DEFAULT NULL COMMENT '记录创建者',
    `updater`            varchar(255)    DEFAULT NULL COMMENT '记录最后更新者',
    `sec_bu_id`          bigint(19)      DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(19)      DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(19)      DEFAULT NULL COMMENT 'sec_ou_id',
    PRIMARY KEY (`id`),
    KEY `create_user_id_index` (`create_user_id`),
    KEY `idx_sys_user_role_role_id` (`role_id`),
    KEY `idx_sys_user_role_user_id` (`user_id`),
    KEY `sec_bu_id_index` (`sec_bu_id`),
    KEY `sec_ou_id_index` (`sec_ou_id`),
    KEY `sec_user_id_index` (`sec_user_id`)
) COMMENT = '用户角色关联表';

CREATE TABLE IF NOT EXISTS `sys_user_terminal`
(
    `id`                 bigint(19)  NOT NULL COMMENT '记录唯一ID',
    `user_id`            bigint(19)  NOT NULL COMMENT '用户ID，sys_user.id',
    `terminal_code`      varchar(64) NOT NULL COMMENT '终端编码，Terminal枚举类',
    `time_bind`          datetime    NULL DEFAULT NULL COMMENT '绑定时间',
    `tenant_id`          bigint(19)       DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255)     DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(19)       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255)     DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime    NULL DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(19)       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255)     DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime    NULL DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(10)     NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(10)          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(19)       DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(19)       DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(19)       DEFAULT NULL COMMENT 'sec_ou_id',
    PRIMARY KEY (`id`),
    KEY `idx_sys_user_terminal_user` (`user_id`)
) COMMENT = '用户与终端的关联';

CREATE TABLE IF NOT EXISTS `sys_watermark_config`
(
    `id`                 bigint(19) NOT NULL COMMENT '记录唯一ID',
    `custom_field`       varchar(128)    DEFAULT NULL COMMENT '自定义文字',
    `stacking_deep`      int(10)         DEFAULT NULL COMMENT '层叠深度',
    `tenant_id`          bigint(19)      DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255)    DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(19)      DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255)    DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime   NULL DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(19)      DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255)    DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime   NULL DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(10)    NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(10)         DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(19)      DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(19)      DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(19)      DEFAULT NULL COMMENT 'sec_ou_id',
    `font_size`          int(10)         DEFAULT NULL COMMENT '文字大小',
    `rotate`             int(10)         DEFAULT NULL COMMENT '旋转角度',
    `field_size`         int(10)         DEFAULT NULL COMMENT '文字大小',
    `rotation_angle`     int(10)         DEFAULT NULL COMMENT '旋转角度',
    `dynamic_font`       varchar(128)    DEFAULT NULL COMMENT '动态文字',
    `font_color`         varchar(255)    DEFAULT NULL COMMENT '颜色深浅',
    `dyna_font`          varchar(255)    DEFAULT NULL COMMENT '动态文字',
    `dynamic_field`      varchar(128)    DEFAULT NULL COMMENT '动态文字',
    PRIMARY KEY (`id`)
) COMMENT = '系统水印配置';

CREATE TABLE IF NOT EXISTS `undo_log`
(
    `id`            bigint(19)   NOT NULL AUTO_INCREMENT COMMENT 'id',
    `branch_id`     bigint(19)   NOT NULL COMMENT 'branch_id',
    `xid`           varchar(100) NOT NULL COMMENT 'xid',
    `context`       varchar(128) NOT NULL COMMENT 'context',
    `rollback_info` longblob     NOT NULL COMMENT 'rollback_info',
    `log_status`    int(10)      NOT NULL COMMENT 'log_status',
    `log_created`   datetime     NOT NULL COMMENT 'log_created',
    `log_modified`  datetime     NOT NULL COMMENT 'log_modified',
    `ext`           varchar(100) DEFAULT NULL COMMENT 'ext',
    PRIMARY KEY (`id`),
    UNIQUE KEY `ux_undo_log` (`xid`, `branch_id`)
) COMMENT = 'undo_log';

CREATE TABLE IF NOT EXISTS `user_join_buid`
(
    `id`                 bigint(19) NOT NULL AUTO_INCREMENT COMMENT '记录唯一ID',
    `userid`             int(10)         DEFAULT NULL COMMENT 'userid',
    `sec_buid`           int(10)         DEFAULT NULL COMMENT 'sec_buid',
    `tenant_id`          bigint(19)      DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255)    DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(19)      DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255)    DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime   NULL DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(19)      DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255)    DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime   NULL DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(10)    NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(10)         DEFAULT NULL COMMENT '锁版本',
    PRIMARY KEY (`id`),
    KEY `create_user_id_index` (`create_user_id`)
) COMMENT = 'user_join_buid';

CREATE TABLE IF NOT EXISTS `user_join_userid`
(
    `id`                 int(10)  NOT NULL AUTO_INCREMENT COMMENT 'id',
    `userid`             int(10)       DEFAULT NULL COMMENT 'userid',
    `sec_userid`         int(10)       DEFAULT NULL COMMENT 'sec_userid',
    `tenant_id`          bigint(19)    DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255)  DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(19)    DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255)  DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime NULL DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(19)    DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255)  DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime NULL DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(10)  NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(10)       DEFAULT NULL COMMENT '锁版本',
    PRIMARY KEY (`id`),
    KEY `create_user_id_index` (`create_user_id`),
    KEY `sec_userid` (`sec_userid`),
    KEY `userid` (`userid`, `sec_userid`)
) COMMENT = 'user_join_userid';

